/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8230.DeviceView;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8230.DeviceView.Builder;
import ibm.nways.jdm8230.DeviceView.BuilderLike;
import ibm.nways.jdm8230.DeviceView.ChassisLike;
import ibm.nways.jdm8230.DeviceView.ChassisUnknown;
import ibm.nways.jdm8230.DeviceView.LateStatusLike;
import ibm.nways.jdm8230.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8230.DeviceView.ModuleLike;
import ibm.nways.jdm8230.DeviceView.Port;
import ibm.nways.jdm8230.DeviceView.PortLike;
import ibm.nways.jdm8230.DeviceView.StatusAttachInfo;
import ibm.nways.jdm8230.DeviceView.StatusRefLike;
import ibm.nways.jdm8230.Jdm8230;
import ibm.nways.ras.RAS;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Chassis
implements ChassisLike {
    public JdmBrowser jdmBrowser;
    public int chassisModel = -1;
    public static final String SYSOID_8230 = "1.3.6.1.4.1.2.6.15";
    public static final int MODEL_003 = 0;
    public static final int MODEL_013 = 1;
    public static final int MODEL_213 = 2;
    public static final int MODEL_04A = 3;
    public static final int MODEL_04P = 4;
    public static final int MODEL_X13 = 5;
    public static final int MODEL_UNKNOWN = -1;
    private static final String[] cauTypeTranslationTable = new String[]{"8230-003", "8230-013", "8230-213", "8230-04A", "8230-04P", "8230-x13"};
    private static final int[] modelTranslationTable;
    protected GraphicContainer graphicContainer = new GraphicContainer();
    protected GraphicContainer container = new GraphicContainer();
    protected static ResourceBundle bundle;
    protected StatusAttachThread statusThread;
    protected MACAddressAttachThread macAddressThread;
    protected Vector macStack = new Vector();
    protected Vector stack = new Vector();
    protected Vector lateStack = new Vector();
    private GraphicPanel graphicPanel;
    private Vector components = new Vector();
    private GenModel portModel;
    private String hubName;
    private String chassisIp = "0.0.0.0";

    public static int modelFromCauType(String string) {
        int n = 0;
        while (n < cauTypeTranslationTable.length) {
            if (cauTypeTranslationTable[n].equals(string)) {
                return modelTranslationTable[n];
            }
            ++n;
        }
        return -1;
    }

    public void dispose() {
        if (this.statusThread != null) {
            this.statusThread.stop();
            this.statusThread = null;
        }
        if (this.macAddressThread != null) {
            this.macAddressThread.stop();
            this.macAddressThread = null;
        }
        this.macStack.removeAllElements();
        this.stack.removeAllElements();
        this.lateStack.removeAllElements();
        if (this.graphicPanel != null) {
            this.graphicPanel.dispose();
            this.graphicPanel = null;
        }
        if (this.graphicContainer != null) {
            this.graphicContainer.dispose();
            this.graphicContainer = null;
        }
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
        this.jdmBrowser = null;
        bundle = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.components.removeAllElements();
    }

    public void draw() {
        GraphicHelp graphicHelp = new GraphicHelp((BrowserApplet)this.jdmBrowser, new Point(0, 0), new HelpRef("ibm.nways.jdm8230", "ibm.nways.jdm8230.BoxGraphic.html"));
        this.container.add((GraphicComponent)graphicHelp);
        this.graphicContainer.setLocation(20, 20);
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            long l = System.currentTimeMillis();
            try {
                leafCompositeLike.draw();
            }
            catch (Exception exception) {
                RAS.logInformation(19, 4, this, "draw", "Exception drawing object -> " + leafCompositeLike.getClass().getName());
                RAS.logException(19, 4, this, "draw", exception);
            }
            long l2 = System.currentTimeMillis();
            if (!RAS.isEnabled(19, 4)) continue;
            RAS.trace(19, 4, this, "draw", "Time to draw component of Chassis -> " + (l2 - l));
        }
        this.container.add(this.graphicContainer);
        this.container.doLayout();
        this.graphicContainer.doLayout();
    }

    public void startStatusThread(Chassis chassis) {
        this.stopStatusThread();
        this.statusThread = chassis.new StatusAttachThread();
        this.statusThread.setName("StatusAttach");
        this.statusThread.start();
    }

    public void stopStatusThread() {
        if (this.statusThread != null) {
            this.statusThread.stop();
            this.statusThread = null;
        }
    }

    public void startMACAddressThread(Chassis chassis) {
        this.stopMACAddressThread();
        this.macAddressThread = chassis.new MACAddressAttachThread();
        this.macAddressThread.setName("macAdreesAttach");
        this.macAddressThread.start();
    }

    public void stopMACAddressThread() {
        if (this.macAddressThread != null) {
            this.macAddressThread.stop();
            this.macAddressThread = null;
        }
    }

    public final void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public final GraphicPanel getGraphicPanel() {
        if (this instanceof ChassisUnknown) {
            return null;
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdmBrowser.getLayout();
        int n = 0;
        float[] fArray = new float[]{0.25f, 0.33f};
        try {
            Properties properties = ((Jdm8230)this.jdmBrowser).getProperties();
            String string = (String)((Hashtable)properties).get("layout.scheme");
            String string2 = (String)((Hashtable)properties).get("layout.fractions");
            if (string != null) {
                n = new Integer(string);
            }
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n2 = 0;
                while (n2 < 2) {
                    fArray[n2] = new Float(stringTokenizer.nextToken()).floatValue();
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 4, this, "getGraphicPanel", exception);
        }
        jdmLayout.setScheme(n);
        jdmLayout.setFracts(fArray);
        if (this.graphicPanel == null) {
            this.graphicPanel = new GraphicPanel((GraphicHandler)this.jdmBrowser, (Component)this.container);
        }
        return this.graphicPanel;
    }

    public final void setJdmBrowser(JdmBrowser jdmBrowser) {
        this.jdmBrowser = jdmBrowser;
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)((GenModel)this.jdmBrowser.getModel()).getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            this.chassisIp = (String)((Object)modelInfo.get("Config.Address"));
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 4, this, "setJdmBrowser", exception);
            return;
        }
    }

    public final void setChassisModel(int n) {
        this.chassisModel = n;
    }

    public String getFlyOver(String string) {
        Object[] objectArray = new Object[]{this.chassisIp};
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat("ibm.nways.jdm8230.DeviceView.GraphicResources", string, objectArray);
        return i18NMsgFormat.getTranslation();
    }

    public GraphicActionNavigate getAction() {
        GraphicActionNavigate graphicActionNavigate = null;
        try {
            GenModel genModel = (GenModel)this.jdmBrowser.getModel();
            GenModel genModel2 = (GenModel)genModel.getComponent("System");
            graphicActionNavigate = new GraphicActionNavigate((GraphicHandler)this.jdmBrowser, new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", (RemoteModel)genModel2), null);
        }
        catch (Exception exception) {
            RAS.logException(19, 4, this, "getAction", exception);
        }
        return graphicActionNavigate;
    }

    public abstract Point getModulePosition(int var1);

    public void discoverChildren() {
        long l;
        int n;
        Point point;
        Integer n2;
        Integer n3;
        GenModel genModel;
        boolean bl = false;
        Vector<Integer> vector = new Vector<Integer>();
        if (RAS.isEnabled(19, 4)) {
            RAS.enter(19, 4, this, "discoveryChildren");
        }
        BuilderLike builderLike = Builder.getInstance();
        new Vector();
        int n4 = 0;
        int n5 = 1;
        int n6 = 190;
        GenModel genModel2 = (GenModel)this.jdmBrowser.getModel();
        try {
            genModel2 = (GenModel)genModel2.getComponent("ConfigurationFolder");
            genModel2 = (GenModel)genModel2.getComponent("SystemFolder");
            genModel2 = (GenModel)genModel2.getComponent("DeviceFolder");
            genModel = null;
            genModel = (GenModel)genModel2.getComponent("ModuleFolder");
            this.portModel = (GenModel)genModel2.getComponent("PortFolder");
            Vector vector2 = genModel.getRestOfInfo("Panel", "default", null, null);
            int n7 = vector2.size();
            n3 = null;
            n2 = null;
            point = null;
            n = 3;
            int n8 = 0;
            while (n8 < n7) {
                Object object;
                n3 = (Integer)((ModelInfo)vector2.elementAt(n8)).get("Index.CauModLocation");
                n2 = (Integer)((ModelInfo)vector2.elementAt(n8)).get("Panel.CauModType");
                if (n2 == 1) {
                    try {
                        Properties properties = ((Jdm8230)this.jdmBrowser).getProperties();
                        String string = new String(n3.toString());
                        object = null;
                        object = (String)((Hashtable)properties).get("LamPortType." + this.chassisIp + "." + string);
                        if (object == null) {
                            object = (String)((Hashtable)properties).get("LamPortType." + this.chassisIp);
                        }
                        if (object == null) {
                            object = (String)((Hashtable)properties).get("LamPortType");
                        }
                        if (object == null) {
                            object = "COOPER_ICS";
                        }
                        if (((String)object).compareTo("COOPER_ICS") == 0) {
                            n = 3;
                        } else if (((String)object).compareTo("COOPER_RJ45") == 0) {
                            n = 4;
                        }
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 4, this, "discoveryChildren", exception);
                    }
                }
                if (n2 == 6) {
                    vector.addElement(n3);
                }
                int n9 = 1;
                int n10 = 1;
                if (n2 == 5) {
                    try {
                        object = (GenModel)genModel2.getComponent("GeneralFolder");
                        ModelInfo modelInfo = object.getInfo("Panel");
                        n9 = (Integer)modelInfo.get("Panel.CauRIMediaType");
                        n10 = (Integer)modelInfo.get("Panel.CauROMediaType");
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 4, this, "discoveryChildren", exception);
                    }
                }
                if (RAS.isEnabled(19, 4)) {
                    RAS.trace(19, 4, this, "discoveryChildren", "Found module " + n2 + " in slot " + n3);
                }
                if (n3 <= 5) {
                    point = this.getModulePosition(n3);
                } else {
                    if (n4 == 1 && n5 == 3) {
                        n6 += 190;
                    } else if (n4 == 1 && n5 == 4) {
                        n6 += 127;
                    }
                    point = new Point(0, n6);
                }
                n4 = n2;
                n5 = n;
                l = System.currentTimeMillis();
                ModuleLike moduleLike = null;
                moduleLike = n2 != 5 ? builderLike.buildModule(this, this.jdmBrowser, genModel, this.portModel, n3, n2, n, this.graphicContainer, this.chassisModel) : builderLike.buildRIRO(this, this.jdmBrowser, genModel, this.portModel, n3, n2, n9, n10, this.graphicContainer, this.chassisModel);
                moduleLike.setLocation(point);
                this.add(moduleLike);
                long l2 = System.currentTimeMillis();
                if (RAS.isEnabled(19, 4)) {
                    RAS.trace(19, 4, this, "discoveryChildren", "Time to build module in slot " + n3 + " -> " + (l2 - l));
                }
                ++n8;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 4, this, "discoveryChildren", exception);
        }
        if (n4 == 1 && n5 == 3) {
            n6 += 190;
        } else if (n4 == 1 && n5 == 4) {
            n6 += 127;
        }
        try {
            genModel = (GenModel)genModel2.getComponent("RLamFolder");
            int n11 = 0;
            Vector vector3 = null;
            if (genModel != null) {
                vector3 = genModel.getRestOfInfo("Panel", "default", null, null);
                n11 = vector3.size();
            } else {
                bl = true;
                n11 = vector.size();
            }
            n3 = null;
            n2 = null;
            point = null;
            n = 0;
            while (n < n11) {
                if (bl) {
                    n2 = (Integer)vector.elementAt(n);
                    n3 = new Integer(3);
                } else {
                    n2 = (Integer)((ModelInfo)vector3.elementAt(n)).get("Index.CauRemoteLamLiuModLocation");
                    n3 = (Integer)((ModelInfo)vector3.elementAt(n)).get("Panel.CauRemoteLamType");
                }
                if (RAS.isEnabled(19, 4)) {
                    RAS.trace(19, 4, this, "discoveryChildren", "Found rlam " + n3 + " in rliu " + n2);
                }
                point = new Point(0, n6);
                n6 += 91;
                long l3 = System.currentTimeMillis();
                ModuleLike moduleLike = builderLike.buildRLam(this, this.jdmBrowser, genModel, this.portModel, n2, n3, this.graphicContainer);
                moduleLike.setLocation(point);
                this.add(moduleLike);
                l = System.currentTimeMillis();
                if (RAS.isEnabled(19, 4)) {
                    RAS.trace(19, 4, this, "discoveryChildren", "Time to build rlam in rliu " + n2 + " -> " + (l - l3));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 4, this, "discoveryChildren", exception);
        }
        this.add(builderLike.buildSpeedSwitch(this, this.jdmBrowser, this.graphicContainer, this.chassisModel));
        if (RAS.isEnabled(19, 4)) {
            RAS.exit(19, 4, this, "discoveryChildren");
        }
    }

    public void askStatus(GenModel genModel, GraphicImage graphicImage, ModelInfo modelInfo, LeafCompositeLike leafCompositeLike) {
        this.stack.addElement(new StatusAttachInfo(genModel, graphicImage, modelInfo, leafCompositeLike));
    }

    public void askMACAddress(PortLike portLike) {
        this.macStack.addElement(portLike);
    }

    public void askStatus(LateStatusLike lateStatusLike) {
        this.lateStack.addElement(lateStatusLike);
    }

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        modelTranslationTable = nArray;
        bundle = ResourceBundle.getBundle("ibm.nways.jdm8230.DeviceView.GraphicResources");
    }

    private class StatusAttachThread
    extends Thread {
        public void run() {
            Object object;
            if (RAS.isEnabled(19, 4)) {
                RAS.enter(19, 4, this, "run");
                RAS.trace(19, 4, this, "run", "Status thread running...");
            }
            Vector vector = Chassis.this.stack;
            synchronized (vector) {
                try {
                    int n = 0;
                    while (n < Chassis.this.stack.size()) {
                        object = (StatusAttachInfo)Chassis.this.stack.elementAt(n);
                        RemoteStatus remoteStatus = null;
                        remoteStatus = ((StatusAttachInfo)object).info != null ? ((StatusAttachInfo)object).model.getStatusRefForRow(((StatusAttachInfo)object).info) : ((StatusAttachInfo)object).model.getStatus("default");
                        StatusProxy statusProxy = new StatusProxy(remoteStatus);
                        ((StatusAttachInfo)object).image.setStatus((Status)statusProxy);
                        if (((StatusAttachInfo)object).object instanceof StatusRefLike) {
                            ((StatusRefLike)((Object)((StatusAttachInfo)object).object)).setStatusRef(statusProxy);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 4, this, "run", exception);
                }
            }
            Chassis.this.stack.removeAllElements();
            vector = Chassis.this.lateStack;
            synchronized (vector) {
                try {
                    int n = 0;
                    while (n < Chassis.this.lateStack.size()) {
                        object = (LateStatusLike)Chassis.this.lateStack.elementAt(n);
                        object.statusesAttached();
                        ++n;
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 4, this, "run", exception);
                }
            }
            Chassis.this.lateStack.removeAllElements();
            if (RAS.isEnabled(19, 4)) {
                RAS.trace(19, 4, this, "run", "End of status thread.");
                RAS.exit(19, 4, this, "run");
            }
        }

        StatusAttachThread() {
            Chassis.this = Chassis.this;
        }
    }

    private class MACAddressAttachThread
    extends Thread {
        public void run() {
            if (RAS.isEnabled(19, 4)) {
                RAS.enter(19, 4, this, "run");
                RAS.trace(19, 4, this, "run", "MACAddress thread running...");
            }
            Vector vector = Chassis.this.macStack;
            synchronized (vector) {
                try {
                    int n = Chassis.this.macStack.size();
                    int n2 = 0;
                    while (n2 < n) {
                        Port port = (Port)Chassis.this.macStack.elementAt(n2);
                        ModelInfo modelInfo = new ModelInfo();
                        modelInfo.add("Index.CauLobeIndex", new Integer(port.lobeIndex - 1));
                        modelInfo.add("Index.CauLobeModLocation", new Integer(port.lobeModLocation));
                        Vector vector2 = port.portTableModel.getNextInfo("Panel", "default", modelInfo, 1);
                        modelInfo = (ModelInfo)vector2.elementAt(0);
                        Serializable serializable = modelInfo.get("Panel.CauLobeMACaddrs");
                        String string = ((OctetString)serializable).toString();
                        int n3 = string.length();
                        int n4 = n3 / 12;
                        String string2 = "";
                        int n5 = 0;
                        while (n5 < n4) {
                            string2 = String.valueOf(string2) + "\n" + string.substring(n5 * 12, (n5 + 1) * 12);
                            ++n5;
                        }
                        port.portGraphicImage.setFlyOver(new GraphicFlyOver(String.valueOf(port.portGraphicImage.getFlyOver().getText()) + string2.toUpperCase()));
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 4, this, "run", exception);
                }
            }
            Chassis.this.macStack.removeAllElements();
            if (RAS.isEnabled(19, 4)) {
                RAS.trace(19, 4, this, "run", "End of MACAddress thread.");
                RAS.exit(19, 4, this, "run");
            }
        }

        MACAddressAttachThread() {
            Chassis.this = Chassis.this;
        }
    }
}

